require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../common/cancel_appointment'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'
require_relative '../../pages/landing_notifications'


describe '[Story# VAR-9670: Remove supported facilities check for traditional VAR appointments; use utility settings to control display for all care types]' do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    TITLE = "Appointments/Requests"

    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    @tenDaysLater = getDateNthDaysFromNow(10, "%m/%d/%Y")
    @sevenDaysFromNow = getDateNthDaysFromNow(7, "%m/%d/%Y")

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "siteSupportingMissingLocation.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "primaryCareDirectSchedulingNewSettings.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    deletePatientData("1113138327")
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysFromNow} 11:00:00")
    @cancel_appointment.cancel_appointment()
    @common.loginEndsOnHome(pw_redacted)
    @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
    @common.selectAddAppointmentButton("VA")

  end

  after(:all) do
    @cancel_appointment.cancel_appointment()
    @driver.close
  end


  context 'AC#VAR-10889|TC#VAR-10990: Remove supported facilities check for traditional VAR appointments; use utility settings to control display for all care types' do

    it 'Only Facilities configured to Yes in VA Tool Set appear in Locations DropDown' do
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("523")
      expected_content =[\
                        "Step 3: Location",
                        "The following facility locations support scheduling #{PRIMARY_CARE} appointments through this app. If you cannot find the location you need, please visit the VA Facility Locator to contact the facility for assistance.",
                        "* Select the location you want to visit:",
                        "Select",
                        "BOSTON HCS VAMC (BOSTON, MA) - Your Primary Care Team",
                        "BROCKTON VAMC (BROCKTON, MA)",
                        "QUINCY (QUINCY, MA)"
      ]

      actual_content = @new_appointment.facility_section_element.text.split("\n")

      compareContents( expected_content, actual_content)

    end

    it 'Can schedule an appointment for a facility missing in siteSupportingVAR collection' do
      @new_appointment.selectLocation("523")
      @new_appointment.selectSchedulingMethod("direct")
      @new_appointment.selectClinic("32")
      @new_appointment.provideReasonForAppointment("This is new Primary Care Request")
      @new_appointment.selectPreferedDate(@sevenDaysFromNow, "11:00")
      @new_appointment.enterEmail("testPC@test.com")
      sleep 2
      @new_appointment.clickScheduleAppointment
      @common.waitWhileSpinnerPresent()
      Watir::Wait.until {@detail.appointment_details_group_element.present?}
      Watir::Wait.until {@detail.appointment_details_group_element.text.include?("Reason for Appointment")}

      expect(@detail.appointment_status_group_element.text).to eq("Status:  Scheduled")

    end
  end
end